<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Регистрация';
?>
<div class="site-register">
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white text-center">
                    <i class="fas fa-user-plus fa-2x mb-3"></i>
                    <h1 class="card-title h3 mb-0"><?= Html::encode($this->title) ?></h1>
                </div>
                <div class="card-body p-4">
                    <?php $form = ActiveForm::begin([
                        'id' => 'register-form',
                        'enableAjaxValidation' => true,
                        'fieldConfig' => [
                            'template' => "{label}\n{input}\n{error}",
                            'inputOptions' => ['class' => 'form-control'],
                            'errorOptions' => ['class' => 'invalid-feedback']
                        ]
                    ]); ?>

                    <div class="mb-3">
                        <?= $form->field($model, 'full_name')->textInput([
                            'autofocus' => true,
                            'placeholder' => 'Иванов Иван Иванович',
                            'class' => 'form-control form-control-lg'
                        ]) ?>
                    </div>

                    <div class="mb-3">
                        <?= $form->field($model, 'phone')->textInput([
                            'placeholder' => '+7 (XXX) XXX-XX-XX',
                            'class' => 'form-control form-control-lg'
                        ]) ?>
                    </div>

                    <div class="mb-3">
                        <?= $form->field($model, 'email')->textInput([
                            'type' => 'email',
                            'placeholder' => 'example@mail.ru',
                            'class' => 'form-control form-control-lg'
                        ]) ?>
                    </div>

                    <div class="mb-3">
                        <?= $form->field($model, 'password')->passwordInput([
                            'class' => 'form-control form-control-lg',
                            'placeholder' => 'Не менее 6 символов'
                        ]) ?>
                    </div>

                    <div class="mb-4">
                        <?= $form->field($model, 'password_repeat')->passwordInput([
                            'class' => 'form-control form-control-lg',
                            'placeholder' => 'Повторите пароль'
                        ]) ?>
                    </div>

                    <div class="mb-4">
                        <?= $form->field($model, 'agree')->checkbox([
                            'template' => "<div class=\"form-check\">{input} {label}</div>\n{error}",
                            'class' => 'form-check-input',
                            'labelOptions' => ['class' => 'form-check-label']
                        ]) ?>
                    </div>

                    <div class="d-grid">
                        <?= Html::submitButton('<i class="fas fa-user-plus me-2"></i>Создать пользователя', [
                            'class' => 'btn btn-success btn-lg'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>

                    <div class="text-center mt-4 pt-3 border-top">
                        <p class="text-muted mb-2">Уже зарегистрированы?</p>
                        <?= Html::a('<i class="fas fa-sign-in-alt me-2"></i>Войти', ['site/login'], [
                            'class' => 'btn btn-outline-primary'
                        ]) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>