<?php

namespace app\models;

use Yii;
use yii\base\Model;

class MemeGame extends Model
{
    public $choice;
    public $score = 0;

    const MEMES = [
        1 => [
            'image' => '🐮',
            'question' => 'Что говорит корова, когда ест траву?',
            'options' => [
                'Му-му-ням' => 1,
                'Ме-е-е-е' => 0,
                'Вкуснятина!' => 0,
                'Молочко будет!' => 0
            ]
        ],
        2 => [
            'image' => '🐔',
            'question' => 'Почему курица перешла дорогу?',
            'options' => [
                'Чтобы показать, что она не индейка' => 0,
                'За экологичным кормом' => 1,
                'Убегала от фермера' => 0,
                'Просто гуляла' => 0
            ]
        ],
        3 => [
            'image' => '🐷',
            'question' => 'Что свинья сказала на фитнесе?',
            'options' => [
                'Хрю-хрю, качаюсь!' => 0,
                'Это не жир, это мышцы!' => 1,
                'Опять бекон качать?' => 0,
                'Я на диете из желудей' => 0
            ]
        ],
        4 => [
            'image' => '🍯',
            'question' => 'Что пчела говорит подруге?',
            'options' => [
                'Медовый день!' => 0,
                'Летим на работу!' => 1,
                'Опять нектар собирать?' => 0,
                'Жуж-жуж, как дела?' => 0
            ]
        ],
        5 => [
            'image' => '🥛',
            'question' => 'Почему молоко белое?',
            'options' => [
                'Потому что коровы едят белые облака' => 0,
                'Это натуральный цвет!' => 1,
                'Чтобы не путать с апельсиновым соком' => 0,
                'От стеснения' => 0
            ]
        ]
    ];

    public function rules()
    {
        return [
            ['choice', 'required', 'message' => 'Выберите ответ!'],
            ['choice', 'string'],
        ];
    }

    public function checkAnswer($memeId)
    {
        $meme = self::MEMES[$memeId];
        return isset($meme['options'][$this->choice]) && $meme['options'][$this->choice] === 1;
    }

    public function getRandomMeme()
    {
        $memeId = array_rand(self::MEMES);
        return [
            'id' => $memeId,
            'data' => self::MEMES[$memeId]
        ];
    }

    public function getFunnyComment($isCorrect)
    {
        $comments = [
            true => [
                "Верно! Ты знаток фермерских мемов! 🌟",
                "Правильно! Настоящий эксперт по эко-юмору! 🎯",
                "Отлично! Ты явно разбираешься в сельском хозяйстве! 👨‍🌾",
                "В точку! Этот ответ достоин фермерской награды! 🏆"
            ],
            false => [
                "Не совсем! Но ты молодец, что пытаешься! 😄",
                "Мимо! Но зато смешно! 🤣",
                "Почти угадал! Попробуй еще раз! 🔄",
                "Неверно! Но настроение поднял! 😊"
            ]
        ];

        return $comments[$isCorrect][array_rand($comments[$isCorrect])];
    }
}