<?php

/** @var yii\web\View $this */

use yii\helpers\Html;

$this->title = 'О нас';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-about">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h1 class="card-title mb-0"><?= Html::encode($this->title) ?></h1>
                </div>
                <div class="card-body">
                    <div class="text-center mb-4">
                        <i class="fas fa-leaf fa-3x text-success mb-3"></i>
                        <h2 class="h4 text-dark">Эко Еда - фермерские продукты с доставкой</h2>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="d-flex">
                                <div class="me-3 text-success">
                                    <i class="fas fa-heart fa-2x"></i>
                                </div>
                                <div>
                                    <h4 class="h5">Наша миссия</h4>
                                    <p class="text-muted">Мы доставляем свежие, экологически чистые продукты прямо от проверенных фермеров к вашему столу.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="d-flex">
                                <div class="me-3 text-success">
                                    <i class="fas fa-award fa-2x"></i>
                                </div>
                                <div>
                                    <h4 class="h5">Качество</h4>
                                    <p class="text-muted">Все продукты проходят строгий контроль качества и имеют сертификаты соответствия.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="d-flex">
                                <div class="me-3 text-success">
                                    <i class="fas fa-truck fa-2x"></i>
                                </div>
                                <div>
                                    <h4 class="h5">Доставка</h4>
                                    <p class="text-muted">Быстрая доставка в удобное для вас время. Сохраняем свежесть продуктов.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="d-flex">
                                <div class="me-3 text-success">
                                    <i class="fas fa-users fa-2x"></i>
                                </div>
                                <div>
                                    <h4 class="h5">Сообщество</h4>
                                    <p class="text-muted">Более 1000 довольных клиентов и 50 проверенных фермерских хозяйств.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="alert alert-info mt-4">
                        <strong>Файл шаблона:</strong> 
                        <code class="d-block mt-2 p-2 bg-light rounded"><?= __FILE__ ?></code>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>