<?php
namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Order;
use app\models\Category;
use app\models\Product;
use yii\web\Response;

class OrderController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['index', 'create'],
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $orders = Order::find()
            ->where(['user_id' => Yii::$app->user->id])
            ->orderBy(['created_at' => SORT_DESC])
            ->all();

        return $this->render('index', [
            'orders' => $orders,
        ]);
    }

    public function actionCreate()
    {
        $model = new Order();

        if ($model->load(Yii::$app->request->post())) {
            $model->user_id = Yii::$app->user->id;
            if ($model->save()) {
                Yii::$app->session->setFlash('success', 'Заявка успешно создана!');
                return $this->redirect(['index']);
            }
        }

        $categories = Category::find()->all();
        $products = Product::find()->all();

        return $this->render('create', [
            'model' => $model,
            'categories' => $categories,
            'products' => $products,
        ]);
    }

    public function actionProducts($category_id)
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $products = Product::find()
            ->where(['category_id' => $category_id])
            ->all();

        $result = [];
        foreach ($products as $product) {
            $result[] = ['id' => $product->id, 'name' => $product->name];
        }

        return $result;
    }
}