<?php
namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\Order;
use app\models\LoginForm;

class AdminController extends Controller
{
    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->redirect(['orders']);
        }

        $model = new LoginForm();
        $model->isAdmin = true;

        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->redirect(['orders']);
        }

        return $this->render('admin-login', [
            'model' => $model,
        ]);
    }

    public function actionOrders()
    {
        if (Yii::$app->user->isGuest) {
            return $this->redirect(['login']);
        }

        $orders = Order::find()
            ->orderBy(['created_at' => SORT_DESC])
            ->all();

        return $this->render('orders', [
            'orders' => $orders,
        ]);
    }

    public function actionUpdateStatus($id, $status)
    {
        $order = Order::findOne($id);
        if ($order) {
            $order->status = $status;
            $order->save();
        }

        return $this->redirect(['orders']);
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->redirect(['login']);
    }
}